#include <bits/stdc++.h>
using namespace std;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<long long> w(N), v(N);
    for(int i=0;i<N;i++){
        cin >> w[i] >> v[i];
    }

    long long vmax = 0;
    for(int i=0;i<N;i++) vmax = max(vmax, v[i]);

    if(vmax == 0){
        cout << 0 << "\n\n";
        return 0;
    }

    double K = eps * vmax / N;
    if(K < 1e-12) K = 1e-12;

    vector<int> vs(N);
    for(int i=0;i<N;i++){
        vs[i] = (int)(v[i] / K);
    }

    int Vsum = 0;
    for(int i=0;i<N;i++) Vsum += vs[i];

    const long long INF = (long long)4e18;
    vector<long long> dp(Vsum+1, INF);
    vector<vector<bool>> take(N, vector<bool>(Vsum+1,false));

    dp[0] = 0;

    for(int i=0;i<N;i++){
        for(int j=Vsum;j>=vs[i];j--){
            if(dp[j-vs[i]] + w[i] < dp[j]){
                dp[j] = dp[j-vs[i]] + w[i];
                take[i][j] = true;
            }
        }
    }

    int best = 0;
    for(int j=0;j<=Vsum;j++){
        if(dp[j] <= W) best = j;
    }

    vector<int> picked;
    int cur = best;
    for(int i=N-1;i>=0;i--){
        if(cur >= vs[i] && take[i][cur]){
            picked.push_back(i+1);
            cur -= vs[i];
        }
    }

    cout << picked.size() << "\n";
    for(int x : picked) cout << x << " ";
    cout << "\n";

    return 0;
}